/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2008 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
*
* AdobePatentID="B564"
* AdobePatentID="B565"
*
**************************************************************************/

//*************************GLOBALS**************************

var _filesListCtrl;
var helpID = MM.ICE_HELP_ManageICEClassesCmd;
// ***************** API  ******************

//--------------------------------------------------------------------
// FUNCTION:
//   commandButtons
//
// DESCRIPTION:
//   Returns the array of buttons that should be displayed on the
//   right hand side of the dialog.  The array is comprised
//   of name, handler function name pairs.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   array of strings - name, handler function name pairs
//--------------------------------------------------------------------
function commandButtons() {
  if (navigator.platform == "Win32")
  {
    return new Array(
              "PutButtonsOnBottom",
              "OkButton defaultButton", MM.BTN_OK, "clickedOK()",
              "CancelButton", MM.BTN_Cancel, "window.close()",
              "PutButtonOnLeft", MM.BTN_Help, "displayHelp()");
  }
  else
  {
    return new Array(
              "PutButtonsOnBottom",
              MM.BTN_Cancel, "window.close()",
              "OkButton defaultButton", MM.BTN_OK, "clickedOK()",
              "PutButtonOnLeft", MM.BTN_Help, "displayHelp()");
  }
}


//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This function is called in the onLoad event. It is responsible
//   for initializing the UI.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function initializeUI() {
  var stylesheetsList = ICEUtils.getStylesheetsList();
  var disabledItems = false;
  var enabledItems = false;

  _filesListCtrl = new StylesheetsList("filesListCtrl");
  _filesListCtrl.setAllValues(stylesheetsList);

  // show the warning
  if (stylesheetsList.length)
  {
    for (var i = 0; i < stylesheetsList.length; i++)
    {
      if (stylesheetsList[i].getDisabled())
      {
        disabledItems = true;
      }
      else
      {
        enabledItems = true;
      }
      if (disabledItems && enabledItems)
      {
        break;
      }
    }
  }

  if (disabledItems)
  {
    var warningEl = document.getElementById("warningContainer");
    if (warningEl)
    {
      warningEl.style.display = "block";
    }
  }
  if (!enabledItems)
  {
    var checkAllEl = document.getElementById("checkAllBtn");
    var uncheckAllEl = document.getElementById("uncheckAllBtn");

    if (checkAllEl)
    {
      checkAllEl.disabled = true;
    }
    if (uncheckAllEl)
    {
      uncheckAllEl.disabled = true;
    }
  }
}


//--------------------------------------------------------------------
// FUNCTION:
//   clickedOK
//
// DESCRIPTION:
//   This function implements the actions to be done when user clicks OK button.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function clickedOK() {
  var theDOM = dw.getDocumentDOM();
  var stylesheetsList = _filesListCtrl.getAllValues();
  var addICENameSpace = false;

  if (stylesheetsList.length)
  {
    for (var i = 0; i < stylesheetsList.length; i++)
    {
      if (!stylesheetsList[i].getDisabled())
      {
        var styleNode = stylesheetsList[i].getNode();
        if (dw.nodeExists(styleNode))
        {
          if (stylesheetsList[i].getChecked())
          {
            styleNode.setAttribute(ICEUtils.allowedStylesAttribute, "*");
            addICENameSpace = true;
          }
          else
          {
            styleNode.removeAttribute(ICEUtils.allowedStylesAttribute);
          }
        }
      }
    }
  }
  if (addICENameSpace)
  {
    ICEUtils.addICENamespace();
  }
  else
  {
    // remove the ICE namespace if there is no ICE markup in page
    ICEUtils.removeICENamespace();
  }

  window.close();
}

//--------------------------------------------------------------------
// FUNCTION:
//   updateUI
//
// DESCRIPTION:
//   This function is called by the UI controls to handle UI updates
//
// ARGUMENTS:
//   controlId - (string) control id
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function updateUI(controlId) {
  if (controlId == "checkAll")
  {
    _filesListCtrl.checkAll(true);
    return;
  }

  if (controlId == "uncheckAll")
  {
    _filesListCtrl.checkAll(false);
    return;
  }
}

//--------------------------------------------------------------------
// FUNCTION:
//   displayHelp
//
// DESCRIPTION:
//   Displays the built-in ICE help.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function displayHelp() {
  ICEUtils.displayHelp(helpID);
}


//--------------------------------------------------------------------
// CLASS:
//   StylesheetsList
//
// DESCRIPTION:
//  This class incorporates the functionality of webkit control.
//  We can refer, in this way, to the webkit control as to a simple list menu.
//
// ARGUMENTS:
//   controlId - id of the webkit control
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
StylesheetsList = function(controlId)
{
  this.browserCtrl = document.getElementById(controlId);
  this.templateFilePath = dw.getConfigurationPath() + "/Shared/ICE/Templates/StyleSheetsListTemplate.html";
  this.customData = null;
};

//--------------------------------------------------------------------
// FUNCTION:
//   getAllValues
//
// DESCRIPTION:
//   This function constructs an array of ICEStyleSheetItem objects.
//
// ARGUMENTS:
//   None
//
// RETURNS:
//   (object) - array of ICEStyleSheetItem objects
//--------------------------------------------------------------------
StylesheetsList.prototype.getAllValues = function()
{
  var retArray = new Array();
  if (this.browserCtrl)
  {
    var browserDOM = this.browserCtrl.getWindow().document;

    if (browserDOM)
    {
      for (var i = 0; i < browserDOM.forms["styleSheetsForm"].elements.length; i++)
      {
        if (browserDOM.forms["styleSheetsForm"].elements[i].type == "checkbox")
        {
          var valueObj = new ICEStylesheetItem();
          valueObj.setLabel(browserDOM.forms["styleSheetsForm"].elements[i].value);
          valueObj.setValue(browserDOM.forms["styleSheetsForm"].elements[i].value);
          if (browserDOM.forms["styleSheetsForm"].elements[i].checked)
          {
            valueObj.setChecked(true);
          }
          else
          {
            valueObj.setChecked(false);
          }
          if (valueObj.value == browserDOM.forms["styleSheetsForm"].elements[i].disabled)
          {
            valueObj.setDisabled(true);
          }
          else
          {
            valueObj.setDisabled(false);
          }
          valueObj.setNode(this.customData[i]);
          retArray.push(valueObj);
        }
      }
    }
  }

  return retArray;
};

//--------------------------------------------------------------------
// FUNCTION:
//   setAllValues
//
// DESCRIPTION:
//   This function generates the html markup need to display all found stylesheets and their associated controls.
//
// ARGUMENTS:
//   valuesObj - (array of objects) ICEStyleSheetItem objects
//
// RETURNS:
//   Nothing
//--------------------------------------------------------------------
StylesheetsList.prototype.setAllValues = function(valuesObj)
{
  var templateDOM = dw.getDocumentDOM(this.templateFilePath);
  this.customData = new Array();
  if (this.browserCtrl && templateDOM)
  {
    templateDOM.body.innerHTML = templateDOM.body.innerHTML.replace(/\{STYLESHEET_URL_HEADER\}/i, dw.loadString("ice/manageICEClasses/cmd/label/stylesheetURL"));
    var newContentStr = "";
    if (valuesObj && valuesObj.length)
    {
      var lineStr = templateDOM.getElementsByTagName("mm:stylesheetLine")[0].innerHTML;

      for(var i = 0; i < valuesObj.length; i++)
      {
        var itemStr = "";
        if (valuesObj[i].getDisabled())
        {
          itemStr = templateDOM.getElementsByTagName("mm:stylesheetItemDisabled")[0].innerHTML;
        }
        else
        {
          itemStr = templateDOM.getElementsByTagName("mm:stylesheetItemEnabled")[0].innerHTML;
        }
        itemStr = itemStr.replace(/\{rowNo\}/ig, i);
        itemStr = itemStr.replace(/\{STYLESHEET_URL\}/ig, valuesObj[i].getLabel());
        if (valuesObj[i].getChecked())
        {
          itemStr = itemStr.replace(/\{checked\}/ig, 'checked="checked"');
        }
        else
        {
          itemStr = itemStr.replace(/\{checked\}/ig, '');
        }
        newContentStr += itemStr + lineStr;
        this.customData[i] = valuesObj[i].getNode();
      }
    }

    var listContentObj = templateDOM.getElementsByTagName("mm:stylesheetList")[0];
    listContentObj.outerHTML = newContentStr;
    if (this.browserCtrl)
    {
      this.browserCtrl.loadHTML(templateDOM.documentElement.outerHTML);
    }
  }
};

//--------------------------------------------------------------------
// FUNCTION:
//   checkAll
//
// DESCRIPTION:
//   This function set the checked state of all enabled stylesheets to true/false depending on the checkParam.
//
// ARGUMENTS:
//   checkParam - (boolean) if false all enabled checkboxes will unchecked, otherwise all checkboxes will be checked
//
// RETURNS:
//   Nothing
//--------------------------------------------------------------------
StylesheetsList.prototype.checkAll = function(checkParam)
{
  if (this.browserCtrl)
  {
    var browserDOM = this.browserCtrl.getWindow().document;

    if (browserDOM)
    {
      for (var i = 0; i < browserDOM.forms["styleSheetsForm"].elements.length; i++)
      {
        if (browserDOM.forms["styleSheetsForm"].elements[i].type == "checkbox" && browserDOM.forms["styleSheetsForm"].elements[i].disabled != true)
        {
          if (checkParam === false)
          {
            browserDOM.forms["styleSheetsForm"].elements[i].checked = false;
          }
          else
          {
            browserDOM.forms["styleSheetsForm"].elements[i].checked = true;
          }
        }
      }
    }
  }

};

